;******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
;* File Name          : 71x_init.s
;* Author             : MCD Application Team
;* Date First Issued  : 06/23/2004
;* Description        : This is the first code executed after RESET.
;*                      This code initializes system stacks and test the P1.8 
;*                      status to jump to the IAP or to the user code program.
;*******************************************************************************
;* History:
;* 09/15/2006 : IAP Version 3.0
;*******************************************************************************
; THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
; CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
; AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
; OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
; OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
; CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
;*******************************************************************************/


; --- Standard definitions of mode bits and interrupt (I & F) flags in PSRs

Mode_USR            EQU    0x10
Mode_FIQ            EQU    0x11
Mode_IRQ            EQU    0x12
Mode_SVC            EQU    0x13
Mode_ABT            EQU    0x17
Mode_UNDEF          EQU    0x1B
Mode_SYS            EQU    0x1F ; available on ARM Arch 4 and later

I_Bit               EQU    0x80 ; when I bit is set, IRQ is disabled
F_Bit               EQU    0x40 ; when F bit is set, FIQ is disabled


; --- System memory locations

RAM_Base            EQU    0x20000000
RAM_Limit           EQU    0x20010000
SRAM_Base           EQU    0x60000000
Stack_Base          EQU    RAM_Limit

;|----------------------------------------------------------------------------------|
;| ---> User code address                                                            |
;|----------------------------------------------------------------------------------|
Flash_Program       EQU    0x40002000


;---------------------------------------------------------------
; ?program_start
;---------------------------------------------------------------
		MODULE	?program_start
		RSEG	IRQ_STACK:DATA(2)
		RSEG	FIQ_STACK:DATA(2)
		RSEG	UND_STACK:DATA(2)
		RSEG	ABT_STACK:DATA(2)		
		RSEG	SVC_STACK:DATA(2)
		RSEG	CSTACK:DATA(2)
		RSEG	ICODE:CODE(2)
		PUBLIC	__program_start
		EXTERN	?main
                CODE32

__program_start:
        LDR     pc, =NextInst
NextInst
		NOP		; Wait for OSC stabilization
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP

       MSR     CPSR_c, #Mode_ABT|F_Bit|I_Bit
       LDR     SP, =SFE(ABT_STACK )& 0xFFFFFFF8

       MSR     CPSR_c, #Mode_UNDEF|F_Bit|I_Bit
       LDR     SP,= SFE(UND_STACK) & 0xFFFFFFF8

       MSR     CPSR_c, #Mode_SVC|F_Bit|I_Bit
       LDR     SP, =SFE(SVC_STACK) & 0xFFFFFFF8

       MSR     CPSR_c, #Mode_FIQ|I_Bit; Change to FIQ mode
       LDR     SP, =SFE(FIQ_STACK)& 0xFFFFFFF8       ; Initialize FIQ stack pointer

       MSR     CPSR_c, #Mode_IRQ|I_Bit; Change to IRQ mode
       LDR     SP, =SFE(IRQ_STACK)& 0xFFFFFFF8        ; Initialize IRQ stack pointer

       MSR     CPSR_c, #Mode_USR  ; Change to User mode, Enable IRQ and FIQ
       LDR     SP, =SFE(CSTACK) & 0xFFFFFFF8     ; Initialize USR stack pointer





; --- Now branches to a C lib function that copies RO data from their
;     load region to their execute region, create the RW and ZI regions
;     then jumps to user C main program.

       B       ?main   ; Note : use B not BL, because an application will
                        ; never return this way

       
       LTORG

       END
;******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****


